# Qualitative Rollouts of Emulators

## Emulator Rollouts for 3D dynamics

The following qualitative rollouts correspond to Figure 6 in the paper.

* Init Seed=0 of KS 3D:
<video controls>
    <source src="videos/emulators_3d/sample_rollouts_scene=3d_diff_ks_seed=0.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

* Init Seed=0 of KS 3D: Absolute Difference against the Reference Solution
<video controls>
    <source src="videos/emulators_3d/sample_rollouts_diff_abs_scene=3d_diff_ks_seed=0.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

* Init Seed=1 of Unbalanced Advection 3D: Absolute Difference against the Reference Solution
<video controls>
    <source src="videos/emulators_3d/sample_rollouts_diff_abs_scene=3d_phy_unbal_adv_seed=1.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

* Init Seed=0 of Burgers 3D (displays all three channels)
<video controls>
    <source src="videos/emulators_3d/ani_burgers_lower_vlim.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

* Init Seed=0 of Swift-Hohenberg 3D: 
<video controls>
    <source src="videos/emulators_3d/sample_rollouts_scene=3d_phy_sh_seed=0.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

### Qualitative Overview of 2D dynamics

* Init Seed=0 of 2D KS:
<video controls>
    <source src="videos/emulators_2d/sample_rollouts_scene=2d_diff_ks_seed=0.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

* Init Seed=0 of 2D Gray-Scott (only the zero-th channel is displayed):
<video controls>
    <source src="videos/emulators_2d/sample_rollouts_scene=2d_phy_gs_theta_seed=0.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

### Qualitative Overview of 1D dynamics

* State rollouts (Reference is at the top, Emulators are in the Rows, Scenarios in the Columns):
<embed src="videos/emulators_1d/sample_rollouts_seed_0.pdf" width="1200px" height="1000px"/>

* Absolute difference to the Reference solution:
<embed src="videos/emulators_1d/sample_rollouts_abs_diff_seed_0.pdf" width="1200px" height="1000px"/>

* Variation across the Init Seeds for UNet in 1D KdV:
<embed src="videos/emulators_1d/sample_rollouts_1d_diff_kdv_UNet;12;2;relu.pdf" width="1200px" height="1800px"/>

# Qualitative Overview of 3D dynamics

These represent the ones shown in the teaser of Figure 1.

* Advection
<video width="320" height="240" controls>
    <source src="videos/references_3d/advection.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

* Kuramoto-Sivashinsky
<video width="320" height="240" controls>
    <source src="videos/references_3d/ks.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

* Gray-Scott
<video width="640" height="240" controls>
    <source src="videos/references_3d/gray_scott.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

* Burgers
<video width="960" height="240" controls>
    <source src="videos/references_3d/burgers.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>
